#include <jsapi.h>
#include <orb/orbit.h>
#include "ScriptServer.h"
#include <stdio.h>

static CORBA_char *
executeScript(PortableServer_Servant servant, CORBA_char *source,
	      CORBA_Environment *ev);

POA_ScriptServer__epv my_ScriptServer_epv = {
    NULL,			/* ORB-private data */
    executeScript
};

PortableServer_ServantBase__epv base_epv = {
    NULL,			/* ORB-private data */
    NULL,			/* servant finalizer */
    NULL			/* default_POA */
};

POA_ScriptServer__vepv my_ScriptServer_vepv = {
    &base_epv,			/* ServantBase vtable */
    &my_ScriptServer_epv	/* ScriptServer vtable */
};

POA_ScriptServer my_ScriptServer_servant = {
    NULL,			/* ORB-private data */
    &my_ScriptServer_vepv
};

int
main(int argc, char *argv[])
{
    PortableServer_ObjectId objid = {0, sizeof("JSScriptServer"),
				     "JSScriptServer"};
    PortableServer_POA poa;
    CORBA_Environment ev;
    char *retval;
    CORBA_ORB orb;
    ScriptServer client = CORBA_OBJECT_NIL;

    CORBA_exception_init(&ev);
    orb = CORBA_ORB_init(&argc, argv, "orbit-local-orb", &ev);
    POA_ScriptServer__init(&my_ScriptServer_servant, &ev);
    
    poa = (PortableServer_POA)
	   CORBA_ORB_resolve_initial_references(orb, "RootPOA", &ev);
    PortableServer_POAManager_activate(PortableServer_POA__get_the_POAManager(poa, &ev), &ev);
    PortableServer_POA_activate_object_with_id(poa, &objid,
					       &my_ScriptServer_servant, &ev);
    client = PortableServer_POA_servant_to_reference(poa,
						     &my_ScriptServer_servant,
						     &ev);
    if (!client) {
	fputs("can't get objref\n", stderr);
	return 1;
    }

    retval = CORBA_ORB_object_to_string(orb, client, &ev);
    fprintf(stdout, "%s\n", retval);
    fflush(stdout);
    CORBA_free(retval);
    CORBA_ORB_run(orb, &ev);
}

static JSRuntime *rt;
static JSContext *cx;
static JSObject *global;

static JSBool
Print(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
{
    uintN i, n;
    JSString *str;

    for (i = n = 0; i < argc; i++) {
        str = JS_ValueToString(cx, argv[i]);
        if (!str)
            return JS_FALSE;
        fprintf(stdout, "%s%s", i ? " " : "", JS_GetStringBytes(str));
    }
    fputc('\n', stdout);
    return JS_TRUE;
}

static JSFunctionSpec globalFunctions[] = {
    {"print", Print, 0},
    {0}
};

static JSClass globalClass = {
  "global", 0,
  JS_PropertyStub,  JS_PropertyStub,  JS_PropertyStub,  JS_PropertyStub,
  JS_EnumerateStub, JS_ResolveStub,   JS_ConvertStub,   JS_FinalizeStub
};

static JSBool
InitJS(void)
{
    rt = JS_NewRuntime(8L * 1024L * 1024L);
    if (!rt)
	return JS_FALSE;
    
    cx = JS_NewContext(rt, 8192);
    if (!cx)
	return JS_FALSE;
    
    global = JS_NewObject(cx, &globalClass, 0, 0);
    if (!global)
	return JS_FALSE;
    
    if (!JS_InitStandardClasses(cx, global))
	return JS_FALSE;
    
    if (!JS_DefineFunctions(cx, global, globalFunctions))
	return JS_FALSE;

    return JS_TRUE;
}

static CORBA_char *
executeScript(PortableServer_Servant servant, CORBA_char *source,
	      CORBA_Environment *ev)
{
    CORBA_char *rv;
    jsval rval;
    JSString *str;
    
    fprintf(stderr, "[server] executing script fragment \"%s\"\n",
	    source);
    if (!rt && !InitJS()) {
	fputs("error initializing JS\n", stderr);
	goto error;
    }
    
    if (!JS_EvaluateScript(cx, global, source, strlen(source),
			   "remote request", 1, &rval)) {
	fputs("error executing JS\n", stderr);
	goto error;
    }

    str = JS_ValueToString(cx, rval);
    if (!str)
	goto error;

    JS_MaybeGC(cx);

    return CORBA_string_dup(JS_GetStringBytes(str));
 error:
	return CORBA_string_dup((CORBA_char *)"error");
}
