#include <stdio.h>
#include <orb/orbit.h>
#include "ScriptServer.h"

ScriptServer server;

int
main(int argc, char *argv[])
{
    CORBA_Environment ev;
    CORBA_ORB orb;
    CORBA_char *rv;
    
    CORBA_exception_init(&ev);
    orb = CORBA_ORB_init(&argc, argv, "orbit-local-orb", &ev);

    if (argc < 2) {
	fputs("[IOR] [script fragment]\n", stderr);
	return 1;
    }
    
    server = CORBA_ORB_string_to_object(orb, argv[1], &ev);
    if (!server) {
	fprintf(stderr, "Can't bind to %s\n", argv[1]);
	return 1;
    }

    rv = ScriptServer_executeScript(server, argv[2], &ev);
    if (ev._major != CORBA_NO_EXCEPTION) {
	fprintf(stderr, "executeScript threw exception %d\n", ev._major);
	return 1;
    }

    printf("[client] script returned \"%s\"\n", rv);
    
    CORBA_Object_release(server, &ev);
    if (ev._major != CORBA_NO_EXCEPTION) {
	fprintf(stderr, "release threw exception %d\n", ev._major);
	return 1;
    }
    
    CORBA_Object_release((CORBA_Object)orb, &ev);
    
    return 0;
}
